<?php
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/jsondb.php";

$slider = db_read_json($SLIDER_FILE, ["slider_speed"=>3000,"breaking_news"=>"","images"=>[]]);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $speed = (int)($_POST["slider_speed"] ?? 3000);
  if ($speed < 1000) $speed = 1000;
  if ($speed > 20000) $speed = 20000;
  $slider["slider_speed"] = $speed;
  db_write_json($SLIDER_FILE, $slider);
  flash_set("success", "Settings saved ✅");
  header("Location: settings.php"); exit;
}
?>
<div class="card p-3">
  <div class="fw-semibold fs-5">Settings</div>
  <div class="text-muted small">Slider auto slide interval in milliseconds.</div>
  <hr>
  <form method="post" class="row g-3">
    <div class="col-12 col-md-6">
      <label class="form-label">Slider Speed (ms)</label>
      <input class="form-control" name="slider_speed" type="number" min="1000" max="20000" value="<?= (int)($slider["slider_speed"] ?? 3000) ?>" required>
      <div class="form-text">Example: 3000 = 3 seconds</div>
    </div>
    <div class="col-12">
      <button class="btn btn-dark"><i class="bi bi-save"></i> Save</button>
    </div>
  </form>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
