<?php
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/jsondb.php";

$slider = db_read_json($SLIDER_FILE, ["slider_speed"=>3000,"breaking_news"=>"","images"=>[]]);

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $news = trim($_POST["breaking_news"] ?? "");
  $slider["breaking_news"] = $news;
  db_write_json($SLIDER_FILE, $slider);
  flash_set("success", "Breaking News updated ✅");
  header("Location: news.php"); exit;
}
?>
<div class="card p-3">
  <div class="d-flex justify-content-between align-items-center">
    <div>
      <div class="fw-semibold fs-5">Breaking News</div>
      <div class="text-muted small">This text will show in your Android app marquee.</div>
    </div>
    <a class="btn btn-outline-dark" href="dashboard.php"><i class="bi bi-arrow-left"></i> Back</a>
  </div>
  <hr>
  <form method="post">
    <label class="form-label">Breaking News Text</label>
    <textarea class="form-control" name="breaking_news" rows="3" required><?= htmlspecialchars($slider["breaking_news"] ?? "") ?></textarea>
    <button class="btn btn-dark mt-3"><i class="bi bi-save"></i> Save</button>
  </form>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
