<?php
require_once __DIR__ . "/includes/auth.php";
require_once __DIR__ . "/includes/ui.php";

if (is_admin_logged_in()) {
  header("Location: dashboard.php"); exit;
}

$error = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $email = trim($_POST["email"] ?? "");
  $pass  = trim($_POST["password"] ?? "");

  if (admin_login($email, $pass)) {
    flash_set("success", "Login successful ✅");
    header("Location: dashboard.php"); exit;
  } else {
    $error = "Login failed! Wrong email/password.";
  }
}
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dingabanga Admin - Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body{background:#f5f7fb}
    .card{border:0;border-radius:18px;box-shadow:0 10px 30px rgba(2,6,23,.08)}
    .btn{border-radius:12px}
  </style>
</head>
<body class="d-flex align-items-center" style="min-height:100vh">
<div class="container">
  <div class="row justify-content-center">
    <div class="col-12 col-md-6 col-lg-4">
      <div class="card p-4">
        <div class="mb-3">
          <div class="fw-bold fs-4">Dingabanga Admin</div>
          <div class="text-muted small">Sign in to start your session</div>
        </div>

        <?php if($error): ?>
          <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="post">
          <label class="form-label">Email</label>
          <input class="form-control mb-3" name="email" placeholder="admin@localhost" required>

          <label class="form-label">Password</label>
          <input class="form-control mb-3" name="password" type="password" placeholder="admin123" required>

          <button class="btn btn-dark w-100">Login</button>
        </form>

        <div class="mt-3 small text-muted">
          Default: admin@localhost / admin123 <br>
          Change in <code>admin/includes/config.php</code>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
