<?php
function db_read_json($file, $default = []) {
  if (!file_exists($file)) return $default;
  $txt = file_get_contents($file);
  $data = json_decode($txt, true);
  return is_array($data) ? $data : $default;
}

function db_write_json($file, $data) {
  $dir = dirname($file);
  if (!is_dir($dir)) @mkdir($dir, 0777, true);

  $fp = fopen($file, 'c+');
  if (!$fp) return false;

  flock($fp, LOCK_EX);
  ftruncate($fp, 0);
  rewind($fp);
  fwrite($fp, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
  fflush($fp);
  flock($fp, LOCK_UN);
  fclose($fp);
  return true;
}
