<?php
require_once __DIR__ . "/auth.php";
require_once __DIR__ . "/ui.php";
require_admin();
$f = flash_get();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Dingabanga Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    :root{ --bg:#f5f7fb; --ink:#0f172a; --muted:#64748b; --brand:#111827; --radius:16px; }
    body{ background:var(--bg); color:var(--ink); }
    .card{ border:0; border-radius:var(--radius); box-shadow:0 10px 30px rgba(2,6,23,.06); }
    .btn{ border-radius:12px; }
    .badge{ border-radius:999px; }
    .sidebar{ background:var(--brand); color:#e5e7eb; min-height:100vh; border-radius:18px; }
    .sidebar a{ color:#e5e7eb; text-decoration:none; display:flex; gap:.6rem; align-items:center; padding:.6rem .8rem; border-radius:12px; }
    .sidebar a:hover{ background:rgba(255,255,255,.08); }
    .sidebar .active{ background:#fff; color:#111827; }
    .topbar{ background:#fff; border-radius:var(--radius); box-shadow:0 8px 24px rgba(2,6,23,.06); }
    .table thead th{ color:var(--muted); font-weight:600 }
  </style>
</head>
<body>
<div class="container-fluid py-3">
  <div class="row g-3">
    <div class="col-12 col-lg-3 col-xl-2">
      <div class="sidebar p-3">
        <div class="mb-3">
          <div class="fw-bold fs-5">Dingabanga</div>
          <div class="small text-white-50">Admin Panel</div>
        </div>
        <?php $page = basename($_SERVER["PHP_SELF"]); ?>
        <nav class="d-grid gap-1">
          <a class="<?= $page==='dashboard.php'?'active':'' ?>" href="dashboard.php"><i class="bi bi-grid"></i> Dashboard</a>
          <a class="<?= $page==='slider.php'?'active':'' ?>" href="slider.php"><i class="bi bi-images"></i> Slider</a>
          <a class="<?= $page==='news.php'?'active':'' ?>" href="news.php"><i class="bi bi-megaphone"></i> Breaking News</a>
          <a class="<?= $page==='users.php'?'active':'' ?>" href="users.php"><i class="bi bi-people"></i> App Users</a>
          <a class="<?= $page==='settings.php'?'active':'' ?>" href="settings.php"><i class="bi bi-gear"></i> Settings</a>
          <a href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
        </nav>
        <div class="mt-4 small text-white-50">
          Logged in: <span class="text-white"><?= h(current_admin_email()) ?></span>
        </div>
      </div>
    </div>

    <div class="col-12 col-lg-9 col-xl-10">
      <div class="topbar p-3 mb-3 d-flex align-items-center justify-content-between">
        <div>
          <div class="fw-semibold">Welcome back 👋</div>
          <div class="small text-muted">Manage slider, breaking news & users</div>
        </div>
        <div class="text-end">
          <div class="small text-muted">Today</div>
          <div class="fw-semibold"><?= date("d M Y, h:i A"); ?></div>
        </div>
      </div>

      <?php if($f): ?>
        <div class="alert alert-<?= h($f["type"]) ?> alert-dismissible fade show" role="alert">
          <?= h($f["msg"]) ?>
          <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
      <?php endif; ?>
