<?php
require_once __DIR__ . "/config.php";

if (session_status() === PHP_SESSION_NONE) {
  session_start();
}

function admin_login($email, $password) {
  global $ADMIN_EMAIL, $ADMIN_PASSWORD;
  if ($email === $ADMIN_EMAIL && $password === $ADMIN_PASSWORD) {
    $_SESSION["admin_logged_in"] = true;
    $_SESSION["admin_email"] = $email;
    return true;
  }
  return false;
}

function admin_logout() {
  $_SESSION = [];
  if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
      $params["path"], $params["domain"],
      $params["secure"], $params["httponly"]
    );
  }
  session_destroy();
}

function is_admin_logged_in() {
  return !empty($_SESSION["admin_logged_in"]);
}

function require_admin() {
  if (!is_admin_logged_in()) {
    header("Location: login.php");
    exit;
  }
}

function current_admin_email() {
  return $_SESSION["admin_email"] ?? "admin";
}
