<?php
require_once __DIR__ . "/includes/header.php";
require_once __DIR__ . "/includes/config.php";
require_once __DIR__ . "/includes/jsondb.php";

$slider = db_read_json($SLIDER_FILE, ["slider_speed"=>3000,"breaking_news"=>"","images"=>[]]);
$users  = db_read_json($USERS_FILE, ["users"=>[]]);

$totalImages = count($slider["images"] ?? []);
$published = 0;
foreach (($slider["images"] ?? []) as $img) if (($img["status"] ?? "") === "published") $published++;
$totalUsers = count($users["users"] ?? []);
?>
<div class="row g-3">
  <div class="col-12 col-md-4">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="text-muted small">Total Slider Images</div>
          <div class="fs-3 fw-bold"><?= (int)$totalImages ?></div>
        </div>
        <div class="fs-2 text-muted"><i class="bi bi-images"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-4">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="text-muted small">Published Images</div>
          <div class="fs-3 fw-bold"><?= (int)$published ?></div>
        </div>
        <div class="fs-2 text-muted"><i class="bi bi-check2-circle"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12 col-md-4">
    <div class="card p-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="text-muted small">App Users Collected</div>
          <div class="fs-3 fw-bold"><?= (int)$totalUsers ?></div>
        </div>
        <div class="fs-2 text-muted"><i class="bi bi-people"></i></div>
      </div>
    </div>
  </div>

  <div class="col-12">
    <div class="card p-3">
      <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
          <div class="fw-semibold">Breaking News</div>
          <div class="text-muted small"><?= htmlspecialchars($slider["breaking_news"] ?? "") ?></div>
        </div>
        <a class="btn btn-dark" href="news.php"><i class="bi bi-pencil"></i> Edit</a>
      </div>
      <hr>
      <div class="d-flex flex-wrap justify-content-between align-items-center gap-2">
        <div>
          <div class="fw-semibold">Slider Speed</div>
          <div class="text-muted small"><?= (int)($slider["slider_speed"] ?? 3000) ?> ms</div>
        </div>
        <a class="btn btn-outline-dark" href="settings.php"><i class="bi bi-gear"></i> Settings</a>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . "/includes/footer.php"; ?>
