<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_FILES['audio']) && isset($_POST['username'])) {
        $username = htmlspecialchars(trim($_POST['username']));

        if (empty($username)) {
            echo json_encode(["status" => "error", "message" => "Username is required"]);
            exit;
        }

        $userDir = 'uploads/' . preg_replace('/[^a-zA-Z0-9_-]/', '', $username);
        if (!is_dir($userDir)) {
            if (!mkdir($userDir, 0777, true)) {
                echo json_encode(["status" => "error", "message" => "Failed to create user directory"]);
                exit;
            }
        }

        $audioFile = $_FILES['audio'];
        $uniqueId = uniqid('audio_', true);
        $filePath = $userDir . '/' . $uniqueId . '.webm';

        if (move_uploaded_file($audioFile['tmp_name'], $filePath)) {
            // Schedule deletion after 10 minutes
            $deletionScript = 'php delete_file.php ' . escapeshellarg($filePath) . ' > /dev/null 2>&1 &';
            exec($deletionScript);

            echo json_encode(["status" => "success", "message" => "Audio uploaded successfully"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to save audio"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Audio file or username missing"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}
?>