<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $username = htmlspecialchars(trim($_GET['username'] ?? ''));

    if (empty($username)) {
        echo json_encode(["status" => "error", "message" => "Username is required"]);
        exit;
    }

    $baseUrl = "https://shitolkar.top/Camerav2/voice/uploads/"; // আপনার সার্ভারের বেস URL
    $userDir = 'uploads/' . preg_replace('/[^a-zA-Z0-9_-]/', '', $username);

    if (!is_dir($userDir)) {
        echo json_encode(["status" => "error", "message" => "No files found for this user"]);
        exit;
    }

    $files = glob($userDir . '/*.webm');
    $fileList = [];

    foreach ($files as $file) {
        $fileList[] = $baseUrl . $username . '/' . basename($file); // সম্পূর্ণ লিংক যোগ
    }

    echo json_encode([
        "status" => "success",
        "message" => "Files retrieved successfully",
        "files" => $fileList
    ]);
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}
?>