<?php
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    if (isset($input['image']) && isset($input['username'])) {
        $base64Image = $input['image'];
        $username = htmlspecialchars(trim($input['username']));

        if (empty($username)) {
            echo json_encode(["status" => "error", "message" => "Username is required"]);
            exit;
        }

        $userDir = 'uploads/' . preg_replace('/[^a-zA-Z0-9_-]/', '', $username);
        if (!is_dir($userDir)) {
            if (!mkdir($userDir, 0777, true)) {
                echo json_encode(["status" => "error", "message" => "Failed to create user directory"]);
                exit;
            }
        }

        $imageData = explode(',', $base64Image)[1] ?? null;
        if (!$imageData) {
            echo json_encode(["status" => "error", "message" => "Invalid image data"]);
            exit;
        }

        $decodedImage = base64_decode($imageData);
        if (!$decodedImage) {
            echo json_encode(["status" => "error", "message" => "Image decoding failed"]);
            exit;
        }

        $uniqueId = uniqid('image_', true);
        $fileName = $userDir . '/' . $uniqueId . '.png';

        if (file_put_contents($fileName, $decodedImage)) {
            echo json_encode(["status" => "success", "message" => "Image uploaded successfully"]);
        } else {
            echo json_encode(["status" => "error", "message" => "Failed to save image"]);
        }
    } else {
        echo json_encode(["status" => "error", "message" => "Image or username data missing"]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method"]);
}
?>