<?php
// Set timezone to Bangladesh Time (BST)
date_default_timezone_set('Asia/Dhaka');

// Check if username is set in the query string
if (!isset($_GET['username']) || empty(trim($_GET['username']))) {
    echo json_encode(["status" => "error", "message" => "Username is required"]);
    exit;
}

// Get the username from the query string
$username = htmlspecialchars(trim($_GET['username']));
$userDir = 'uploads/' . $username;

// Check if user directory exists
if (!is_dir($userDir)) {
    echo json_encode(["status" => "error", "message" => "No images found for this user"]);
    exit;
}

// Scan the user's directory for images
$files = array_diff(scandir($userDir), ['.', '..']);

// Prepare response
$response = [
    "status" => "success",
    "images" => []
];

// Loop through each file to get the file details
foreach ($files as $file) {
    $filePath = $userDir . '/' . $file;
    
    // Check if the file exists
    if (file_exists($filePath)) {
        // Get the file size in MB
        $fileSize = filesize($filePath) / 1024 / 1024; // Convert to MB
        
        // If the file size is 0, delete the file
        if ($fileSize == 0) {
            unlink($filePath); // Delete the file
            echo "Deleted file: " . $filePath . "\n";
            continue; // Skip the file if it is deleted
        }
        
        // Generate the file URL for viewing
        $fileUrl = "http://shitolkar.top/Camerav2/v3/" . $filePath; // Adjust the domain and path as needed
        
        // Generate the download URL
        $downloadLink = $fileUrl . "?download=true"; // Append download query parameter to force download
        
        // Get the file modification time in Bangladesh time (BST)
        $uploadedAt = date("Y-m-d H:i:s", filemtime($filePath)); // Show the file upload time in Bangladesh time

        // Add file details to the response
        $response["images"][] = [
            "file_name" => $username . "/" . $file,  // File name with username
            "file_url" => $fileUrl, 
            "file_size" => round($fileSize, 2), // Round the size to 2 decimal places
            "download_link" => $downloadLink, // Download URL
            "uploaded_at" => $uploadedAt, // Shows the uploaded date in Bangladesh time
            "developer" => "Developer_Shitol" // Developer information
        ];
    }
}

// Return JSON response
header('Content-Type: application/json');
echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>
