<?php
// Define the path to the main directory
$mainDir = 'uploads/';

// Get all the directories (which are user names)
$dirs = array_diff(scandir($mainDir), ['.', '..']);

// Loop through each user directory
foreach ($dirs as $username) {
    $userDir = $mainDir . $username;

    // Check if the directory exists
    if (is_dir($userDir)) {
        // Check the last modified time of the directory
        $lastModified = filemtime($userDir);

        // If the directory is older than 10 minutes (600 seconds)
        if (time() - $lastModified > 300) { // 10 minutes = 600 seconds
            // Delete all files in the user directory
            $files = array_diff(scandir($userDir), ['.', '..']);
            foreach ($files as $file) {
                $filePath = $userDir . '/' . $file;

                // Delete the file
                if (file_exists($filePath)) {
                    unlink($filePath);
                    echo "Deleted file: " . $filePath . "\n";
                }
            }

            // Delete the user directory itself
            rmdir($userDir);
            echo "Deleted user directory: " . $userDir . "\n";
        }
    }
}
?>