<?php
// ফাইল সংরক্ষণের ডিরেক্টরি
$dataDir = "user_data";

// ডিরেক্টরি না থাকলে তৈরি করুন
if (!file_exists($dataDir)) {
    mkdir($dataDir, 0777, true);
}

// ইউজারের তথ্য সংগ্রহ
$userAgent = $_SERVER['HTTP_USER_AGENT'];
$userIP = $_SERVER['REMOTE_ADDR'];
$deviceName = gethostbyaddr($userIP);
$requestTime = date("Y-m-d H:i:s");

// URL প্যারামিটার থেকে ইউজারনেম সংগ্রহ
$username = isset($_GET['username']) ? $_GET['username'] : "unknown_user";

// ব্যবহারকারীর ডেটা
$userData = [
    "username" => $username,
    "ip_address" => $userIP,
    "device_name" => $deviceName,
    "user_agent" => $userAgent,
    "request_time" => $requestTime,
];

// ফাইলের নাম (ইউজারনেম ভিত্তিক)
$fileName = $dataDir . DIRECTORY_SEPARATOR . $username . ".json";

// ডেটা ফাইলে লিখুন এবং সফলতার মেসেজ দেখান
if (file_put_contents($fileName, json_encode($userData, JSON_PRETTY_PRINT))) {
    echo json_encode([
        "status" => "success",
        "message" => "User data has been successfully saved.",
        "data" => $userData
    ], JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to save user data."
    ], JSON_PRETTY_PRINT);
}

// ১০ মিনিট পর ফাইল মুছে ফেলুন
register_shutdown_function(function () use ($fileName) {
    sleep(600); // ১০ মিনিট অপেক্ষা করুন
    if (file_exists($fileName)) {
        unlink($fileName); // ফাইল মুছে ফেলুন
    }
});

// ব্যবহারকারীর ডিভাইসের নামের জন্য সহায়ক ফাংশন
function getDeviceName()
{
    $userAgent = $_SERVER['HTTP_USER_AGENT'];
    if (preg_match('/Android/i', $userAgent)) {
        return "Android Device";
    } elseif (preg_match('/iPhone/i', $userAgent)) {
        return "iPhone";
    } elseif (preg_match('/iPad/i', $userAgent)) {
        return "iPad";
    } elseif (preg_match('/Windows/i', $userAgent)) {
        return "Windows PC";
    } elseif (preg_match('/Macintosh/i', $userAgent)) {
        return "Macintosh";
    } else {
        return "Unknown Device";
    }
}
?>