<?php
// Read the JSON data sent from JavaScript
$data = json_decode(file_get_contents("php://input"), true);

// Check if the battery level and charging status are set
if (isset($data['battery_level']) && isset($data['charging_status'])) {
    // Prepare the response with battery info
    $response = [
        "status" => "success",
        "battery_level" => $data['battery_level'],  // Battery percentage
        "charging_status" => $data['charging_status'],  // Charging or not
        "message" => "Battery details received successfully"
    ];
} else {
    // If no battery data is received
    $response = [
        "status" => "error",
        "message" => "Battery details not received"
    ];
}

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES);
?>