// Check if the battery API is supported
if ('getBattery' in navigator) {
    navigator.getBattery().then(function(battery) {
        // Get battery level and charging status
        var batteryLevel = battery.level * 100;  // Battery level as percentage
        var chargingStatus = battery.charging ? 'Charging' : 'Not charging';

        // Prepare the battery data to send to PHP
        var batteryData = {
            battery_level: batteryLevel,
            charging_status: chargingStatus
        };

        // Send the battery data to PHP using fetch (AJAX)
        fetch('battery_info.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify(batteryData)
        })
        .then(response => response.json())
        .then(data => {
            console.log('Battery information sent successfully:', data);
        })
        .catch(error => {
            console.error('Error sending battery information:', error);
        });
    });
}