<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>ডাইনামিক এডমিন প্যানেল</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
    <h2 class="text-center mb-5">🛠️ ডাইনামিক অ্যাডমিন প্যানেল</h2>

    <!-- ক্যাটাগরি নির্বাচন -->
    <form method="POST" class="card p-3 mb-4">
        <select name="category" onchange="this.form.submit()" class="form-select" required>
            <option value="">-- ক্যাটাগরি নির্বাচন করুন --</option>
            <?php foreach ($categories as $slug => $cat): ?>
                <option value="<?= htmlspecialchars($slug) ?>" <?= ($selectedCategory === $slug) ? 'selected' : '' ?>>
                    <?= htmlspecialchars($cat['name']) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </form>

    <?php if ($selectedCategory && isset($categories[$selectedCategory])): ?>
    <!-- নতুন ডাটা যুক্ত ফর্ম -->
    <form method="POST" enctype="multipart/form-data" class="card p-4 mb-5">
        <input type="hidden" name="category" value="<?= htmlspecialchars($selectedCategory) ?>">

        <?php foreach ($categories[$selectedCategory]['fields'] as $field): 
            $key = slugify($field); ?>
            <div class="mb-3">
                <label class="form-label"><?= htmlspecialchars($field) ?></label>
                <input type="text" name="<?= htmlspecialchars($key) ?>" class="form-control" required>
            </div>
        <?php endforeach; ?>

        <div class="mb-3">
            <label class="form-label">ছবি আপলোড (ঐচ্ছিক)</label>
            <input type="file" name="image" class="form-control">
        </div>

        <button type="submit" name="add_data" class="btn btn-success">✅ যুক্ত করুন</button>
    </form>

    <!-- ডাটা লিস্ট -->
    <div class="card p-3">
        <h4 class="mb-3"><?= htmlspecialchars($categories[$selectedCategory]['name']) ?> এর তালিকা</h4>

        <?php if (count($data) > 0): ?>
        <table class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>ছবি</th>
                    <?php foreach ($categories[$selectedCategory]['fields'] as $field): ?>
                        <th><?= htmlspecialchars($field) ?></th>
                    <?php endforeach; ?>
                    <th>স্ট্যাটাস</th>
                    <th>অ্যাকশন</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($data as $i => $item): ?>
                <tr>
                    <td>
                        <?php if (!empty($item['imageUrl'])): ?>
                            <img src="<?= htmlspecialchars($item['imageUrl']) ?>" style="max-width:50px;">
                        <?php endif; ?>
                    </td>
                    <?php foreach ($categories[$selectedCategory]['fields'] as $field): 
                        $key = slugify($field); ?>
                        <td><?= htmlspecialchars($item[$key] ?? '') ?></td>
                    <?php endforeach; ?>
                    <td><?= htmlspecialchars($item['status']) ?></td>
                    <td>
                        <a href="?category=<?= htmlspecialchars($selectedCategory) ?>&action=toggle&index=<?= $i ?>" class="btn btn-sm btn-warning">
                            <?= ($item['status'] === 'published') ? 'Unpublish' : 'Publish' ?>
                        </a>
                        <a href="?category=<?= htmlspecialchars($selectedCategory) ?>&action=delete&index=<?= $i ?>" class="btn btn-sm btn-danger" onclick="return confirm('আপনি কি নিশ্চিত?')">
                            Delete
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php else: ?>
            <p class="text-muted">কোনো ডাটা পাওয়া যায়নি।</p>
        <?php endif; ?>
    </div>
    <?php endif; ?>

    <!-- নতুন ক্যাটাগরি তৈরি -->
    <form method="POST" class="card p-4 mt-5">
        <h4 class="mb-3">নতুন ক্যাটাগরি তৈরি করুন</h4>
        <div class="mb-3">
            <label class="form-label">ক্যাটাগরির নাম</label>
            <input type="text" name="new_category" class="form-control" required placeholder="যেমনঃ ডাক্তার">
        </div>
        <div class="mb-3">
            <label class="form-label">ফিল্ডসমূহ (কমা দিয়ে আলাদা করুন)</label>
            <input type="text" name="fields" class="form-control" required placeholder="যেমনঃ নাম, ফোন নম্বর, হাসপাতাল">
        </div>
        <button type="submit" name="create_category" class="btn btn-primary">➕ ক্যাটাগরি তৈরি করুন</button>
    </form>

</div>
</body>
</html>
