<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Advanced Slider Admin Panel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background-color: #f8f9fa;
      font-family: 'Segoe UI', sans-serif;
    }
    .card img {
      height: 200px;
      object-fit: cover;
      border-radius: 6px;
    }
    .btn-sm {
      font-size: 0.8rem;
      padding: 0.25rem 0.5rem;
    }
    .upload-box, .json-box, .settings-box {
      background: white;
      border-radius: 12px;
      padding: 20px;
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
      margin-bottom: 30px;
    }
    .json-box code {
      word-break: break-all;
    }
  </style>
</head>
<body>
  <div class="container py-5">
    <h2 class="mb-4 text-center">🛠️ Advanced Slider Admin Panel</h2>

    <div class="upload-box mb-4">
      <h5>📤 Upload New Image</h5>
      <form method="POST" action="upload.php" enctype="multipart/form-data" class="row g-2 align-items-end">
        <div class="col-md-5">
          <input type="file" name="image" class="form-control" required />
        </div>
        <div class="col-md-3">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="crop" id="cropCheck" checked>
            <label class="form-check-label" for="cropCheck">
              ✂️ Auto Crop to 1080×540
            </label>
          </div>
        </div>
        <div class="col-md-2">
          <button type="submit" class="btn btn-primary w-100">Upload</button>
        </div>
      </form>
    </div>

    <div class="settings-box mb-4">
      <h5>⚙️ Slider Settings</h5>
      <?php 
        $config = json_decode(file_get_contents('config.json'), true);
        $speed = $config['slider_speed'] ?? 3000;
        $breaking_news = $config['breaking_news'] ?? '';
      ?>
      <form method="POST" action="update_settings.php" class="row g-3">
        <div class="col-md-6">
          <label for="sliderSpeed" class="form-label">Slider Speed (ms)</label>
          <input type="number" name="slider_speed" id="sliderSpeed" class="form-control" value="<?= $speed ?>" required />
        </div>
        <div class="col-md-6">
          <label for="breakingNews" class="form-label">Breaking News</label>
          <input type="text" name="breaking_news" id="breakingNews" class="form-control" value="<?= htmlspecialchars($breaking_news) ?>" />
        </div>
        <div class="col-12">
          <button type="submit" class="btn btn-success">💾 Save Settings</button>
        </div>
      </form>
    </div>

    <div class="row">
      <?php require 'functions.php'; $data = loadData(); ?>
      <?php foreach ($data as $index => $item): ?>
        <div class="col-md-4">
          <div class="card mb-4">
            <img src="uploads/<?= $item['filename'] ?>" class="card-img-top" alt="..." />
            <div class="card-body">
              <p class="card-text mb-2">
                Status: <strong><?= $item['published'] ? '✅ Published' : '🚫 Unpublished' ?></strong>
              </p>
              <div class="d-flex flex-wrap gap-2">
                <a href="toggle.php?index=<?= $index ?>" class="btn btn-outline-secondary btn-sm">🔁 Toggle</a>
                <a href="delete.php?index=<?= $index ?>" class="btn btn-outline-danger btn-sm" onclick="return confirm('Delete this image?')">❌ Delete</a>
              </div>
              <form method="POST" action="replace.php" enctype="multipart/form-data" class="mt-3">
                <input type="hidden" name="index" value="<?= $index ?>" />
                <input type="file" name="image" class="form-control form-control-sm mb-2" required />
                <button type="submit" class="btn btn-warning btn-sm w-100">🔄 Replace</button>
              </form>
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    </div>

    <div class="json-box">
      <h5>📄 JSON Output Link</h5>
      <p>Use this URL in your app:</p>
      <code><?= $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) ?>/api.php</code>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
