<?php
header('Content-Type: application/json');

// Load images
$images = file_exists('data.json') 
    ? json_decode(file_get_contents('data.json'), true) 
    : [];

// Load config settings
$config = file_exists('config.json') 
    ? json_decode(file_get_contents('config.json'), true)
    : ['slider_speed' => 3000, 'breaking_news' => ''];

// Format images array (send all with actual status)
$imageOutput = [];

foreach ($images as $img) {
    $imageOutput[] = [
        'url' => 'uploads/' . $img['filename'],
        'status' => $img['published'] ? 'published' : 'unpublished'
    ];
}

// Final output
$output = [
    'slider_speed' => $config['slider_speed'],
    'breaking_news' => $config['breaking_news'],
    'images' => $imageOutput
];

echo json_encode($output, JSON_PRETTY_PRINT);
?>
