<?php
date_default_timezone_set("Asia/Dhaka"); // বাংলাদেশ সময় সেট

$transactions_file = "transactions.json";

// আগের ডেটা লোড করো
$transactions = file_exists($transactions_file) ? json_decode(file_get_contents($transactions_file), true) : [];

$transaction_id = $_POST['transaction_id'] ?? '';
$message = $_POST['message'] ?? '';
$response = '';

// ফাঁকা ইনপুট চেক
if (empty($transaction_id)) {
    echo "❌ ট্রানজেকশন আইডি দেওয়া হয়নি।";
    exit;
}

// ডুপ্লিকেট চেক
$exists = false;
foreach ($transactions as $tx) {
    if (isset($tx['transaction_id']) && $tx['transaction_id'] === $transaction_id) {
        $exists = true;
        break;
    }
}

if ($exists) {
    echo "⚠️ এই ট্রানজেকশন আইডি ইতিমধ্যে সাবমিট হয়েছে!";
} else {
    $new_transaction = [
        "transaction_id" => $transaction_id,
        "message" => $message,
        "time" => date("Y-m-d H:i:s")
    ];

    $transactions[] = $new_transaction;
    file_put_contents($transactions_file, json_encode($transactions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    echo "✅ ট্রানজেকশন সফলভাবে সাবমিট হয়েছে!";
}
?>
