<?php
date_default_timezone_set("Asia/Dhaka");

$methods_file = "payment_methods.json";
$output_file = "payment_output.json";
$transactions_file = "transactions.json";

$default_data = [
    "bkash" => [
        "title" => "বিকাশ পেমেন্ট নাম্বার",
        "number" => "",
        "instruction" => ""
    ],
    "nagad" => [
        "title" => "নগদ পেমেন্ট নাম্বার",
        "number" => "",
        "instruction" => ""
    ]
];

// Initialize method files
if (!file_exists($methods_file)) {
    file_put_contents($methods_file, json_encode($default_data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// Load methods and transactions
$methods = json_decode(file_get_contents($methods_file), true);
$transactions = file_exists($transactions_file) ? json_decode(file_get_contents($transactions_file), true) : [];

$message = "";

// 🧩 Mark as read functionality
if (isset($_GET['mark_read'])) {
    $txId = $_GET['mark_read'];
    foreach ($transactions as &$tx) {
        if ($tx['transaction_id'] === $txId) {
            $tx['read'] = true;
            break;
        }
    }
    unset($tx);
    file_put_contents($transactions_file, json_encode($transactions, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    header("Location: " . strtok($_SERVER["REQUEST_URI"], '?'));
    exit;
}

// 🔄 Update method data
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $method = $_POST['method'] ?? '';
    $number = $_POST['number'] ?? '';
    $instruction = $_POST['instruction'] ?? '';

    if (in_array($method, ['bkash', 'nagad'])) {
        $methods[$method]['number'] = $number;
        $methods[$method]['instruction'] = $instruction;

        file_put_contents($methods_file, json_encode($methods, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        file_put_contents($output_file, json_encode($methods, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

        $message = "✅ " . strtoupper($method) . " তথ্য সফলভাবে আপডেট হয়েছে!";
    } else {
        $message = "❌ ভুল মেথড নির্বাচন করা হয়েছে।";
    }
}
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>পেমেন্ট অ্যাডমিন</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: #f1f3f6;
            font-family: 'Segoe UI', sans-serif;
        }
        .app-header {
            background: #4a90e2;
            color: white;
            padding: 20px;
            border-radius: 0 0 20px 20px;
            text-align: center;
            box-shadow: 0 2px 6px rgba(0,0,0,0.1);
        }
        .section {
            margin-top: 25px;
        }
        .card {
            border-radius: 16px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .form-control, .form-select {
            border-radius: 10px;
        }
        .btn-primary {
            border-radius: 10px;
        }
        .list-group-item {
            border: none;
            padding: 10px 15px;
        }
        .time-text {
            font-size: 0.9em;
            color: #666;
        }
        .badge-new {
            background-color: #d32f2f;
            color: white;
            font-size: 0.7rem;
            padding: 3px 6px;
            border-radius: 5px;
            margin-left: 10px;
        }
    </style>
</head>
<body>

<div class="app-header">
    <h2>🔧 পেমেন্ট অ্যাডমিন প্যানেল</h2>
    <p class="mb-0">পেমেন্ট তথ্য ও ট্রানজেকশন পরিচালনা</p>
</div>

<div class="container mt-4 mb-5">

    <?php if (!empty($message)): ?>
        <div class="alert alert-success"><?= $message ?></div>
    <?php endif; ?>

    <!-- 🔄 তথ্য আপডেট ফর্ম -->
    <div class="section">
        <div class="card p-4">
            <h5 class="mb-3">✏️ তথ্য আপডেট করুন</h5>
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">মেথড নির্বাচন করুন:</label>
                    <select name="method" class="form-select" required>
                        <option value="">-- নির্বাচন করুন --</option>
                        <option value="bkash">বিকাশ</option>
                        <option value="nagad">নগদ</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label">নাম্বার:</label>
                    <input type="text" name="number" class="form-control" placeholder="০১৭xxxxxxxx" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">ইনস্ট্রাকশন:</label>
                    <textarea name="instruction" class="form-control" rows="3" required></textarea>
                </div>
                <button type="submit" class="btn btn-primary w-100">✅ আপডেট করুন</button>
            </form>
        </div>
    </div>

    <!-- 📄 বর্তমান তথ্য -->
    <div class="section">
        <div class="card p-4">
            <h5 class="mb-3">📄 বর্তমান পেমেন্ট ইনফো</h5>
            <ul class="list-group">
                <li class="list-group-item bg-light rounded mb-2">
                    <strong>বিকাশ:</strong> <?= htmlspecialchars($methods['bkash']['number']) ?><br>
                    <em><?= nl2br(htmlspecialchars($methods['bkash']['instruction'])) ?></em>
                </li>
                <li class="list-group-item bg-light rounded">
                    <strong>নগদ:</strong> <?= htmlspecialchars($methods['nagad']['number']) ?><br>
                    <em><?= nl2br(htmlspecialchars($methods['nagad']['instruction'])) ?></em>
                </li>
            </ul>
        </div>
    </div>

    <!-- 📋 ট্রানজেকশন হিস্টোরি -->
    <div class="section">
        <div class="card p-4">
            <h5 class="mb-3">📋 ট্রানজেকশন হিস্টোরি</h5>
            <?php if (!empty($transactions)): ?>
                <ul class="list-group">
                    <?php foreach (array_reverse($transactions) as $tx): ?>
                        <?php $isNew = !isset($tx['read']) || !$tx['read']; ?>
                        <li class="list-group-item bg-white rounded shadow-sm mb-2">
                            <div>
                                <strong>🆔 <?= htmlspecialchars($tx["transaction_id"] ?? "N/A") ?></strong>
                                <?php if ($isNew): ?>
                                    <span class="badge-new">🆕 নিউ</span>
                                <?php endif; ?>
                            </div>
                            <div><?= htmlspecialchars($tx["message"] ?? "") ?></div>
                            <div class="time-text">🕒 <?= date("d M Y, h:i A", strtotime($tx["time"] ?? "")) ?> (BD)</div>

                            <?php if ($isNew): ?>
                                <a href="?mark_read=<?= urlencode($tx["transaction_id"]) ?>" class="btn btn-sm btn-outline-success mt-2">পড়েছি ✅</a>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            <?php else: ?>
                <p class="text-muted text-center">🙁 এখনো কোনো ট্রানজেকশন পাওয়া যায়নি।</p>
            <?php endif; ?>
        </div>
    </div>

</div>

</body>
</html>
