<?php
$jsonFile = 'data.json';

function readDataFromJson() {
    global $jsonFile;
    if (file_exists($jsonFile)) {
        $data = file_get_contents($jsonFile);
        return json_decode($data, true);
    } else {
        return [];
    }
}

function writeDataToJson($data) {
    global $jsonFile;
    file_put_contents($jsonFile, json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel - Contact Info</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- Bootstrap CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f4f6f8;
            margin: 0;
            padding: 0;
        }
        .header {
            background-color: #0d6efd;
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 22px;
            font-weight: 600;
        }
        .card {
            border-radius: 16px;
            padding: 20px;
            margin: 20px auto;
            max-width: 500px;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
            background-color: white;
        }
        .form-label {
            font-weight: 500;
        }
        .btn-primary {
            border-radius: 10px;
            font-weight: bold;
        }
        .alert {
            max-width: 500px;
            margin: 20px auto;
        }
        input {
            border-radius: 8px !important;
        }
    </style>
</head>
<body>

    <div class="header">
        Update Contact Info
    </div>

    <div class="container">
        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $facebook = $_POST['facebook'];
            $call = $_POST['call'];
            $whatsapp = $_POST['whatsapp'];
            $email = $_POST['email'];
            $location = $_POST['location'];
            $developer = $_POST['developer'];

            $data = readDataFromJson();
            $data['facebook'] = $facebook;
            $data['call'] = $call;
            $data['whatsapp'] = $whatsapp;
            $data['email'] = $email;
            $data['location'] = $location;
            $data['developer'] = $developer;

            writeDataToJson($data);

            echo '<div class="alert alert-success text-center">✅ তথ্য সফলভাবে সংরক্ষণ করা হয়েছে!</div>';
        }

        $data = readDataFromJson();
        ?>

        <div class="card">
            <form method="POST" action="">
                <div class="mb-3">
                    <label class="form-label">📘 Facebook URL</label>
                    <input type="text" class="form-control" name="facebook" value="<?= $data['facebook'] ?? '' ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">📞 Call Number</label>
                    <input type="text" class="form-control" name="call" value="<?= $data['call'] ?? '' ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">💬 WhatsApp Number</label>
                    <input type="text" class="form-control" name="whatsapp" value="<?= $data['whatsapp'] ?? '' ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">✉️ Email</label>
                    <input type="email" class="form-control" name="email" value="<?= $data['email'] ?? '' ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">📍 Location</label>
                    <input type="text" class="form-control" name="location" value="<?= $data['location'] ?? '' ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">👨‍💻 Developer Info</label>
                    <input type="text" class="form-control" name="developer" value="<?= $data['developer'] ?? '' ?>" required>
                </div>
                <button type="submit" class="btn btn-primary w-100 mt-2">💾 Save Info</button>
            </form>
        </div>
    </div>

</body>
</html>
