<?php
$jsonFile = 'blood_donors.json';

$input = json_decode(file_get_contents('php://input'), true);

$index = isset($input['index']) ? $input['index'] : '';
$updatedDonor = isset($input['updatedDonor']) ? $input['updatedDonor'] : null;

if ($index !== '' && $updatedDonor !== null) {
    if (file_exists($jsonFile)) {
        $data = file_get_contents($jsonFile);
        $donors = json_decode($data, true);
        
        if (isset($donors[$index])) {
            $donors[$index] = $updatedDonor;

            if (file_put_contents($jsonFile, json_encode($donors, JSON_PRETTY_PRINT))) {
                echo json_encode(["status" => "success", "message" => "Donor updated successfully"]);
            } else {
                echo json_encode(["status" => "failed", "message" => "Failed to update the donor"]);
            }
        } else {
            echo json_encode(["status" => "failed", "message" => "Donor not found"]);
        }
    } else {
        echo json_encode(["status" => "failed", "message" => "File not found"]);
    }
} else {
    echo json_encode(["status" => "failed", "message" => "Invalid parameters"]);
}
?>
