<?php
// ফোল্ডার তৈরি করে নিই যদি না থাকে
if (!file_exists('data')) mkdir('data', 0777, true);
if (!file_exists('uploads')) mkdir('uploads', 0777, true);

// ক্যাটাগরির তালিকা লোড
function loadCategories() {
    $file = 'data/categories_list.json';
    if (!file_exists($file)) file_put_contents($file, json_encode([], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    return json_decode(file_get_contents($file), true);
}

// ক্যাটাগরির তালিকা সেভ
function saveCategories($categories) {
    file_put_contents('data/categories_list.json', json_encode($categories, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

// নির্দিষ্ট ক্যাটাগরির ডাটা লোড
function loadData($slug) {
    $file = "data/{$slug}.json";
    if (!file_exists($file)) file_put_contents($file, json_encode([], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    return json_decode(file_get_contents($file), true);
}

// নির্দিষ্ট ক্যাটাগরির ডাটা সেভ
function saveData($slug, $data) {
    file_put_contents("data/{$slug}.json", json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

// টেক্সটকে slug বানানো
function slugify($text) {
    $text = preg_replace('~[^\pL\d]+~u', '_', $text);
    $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
    $text = preg_replace('~[^-\w]+~', '', $text);
    $text = trim($text, '_');
    $text = preg_replace('~_+~', '_', $text);
    $text = strtolower($text);
    return $text ?: 'n_a';
}
?>
