<?php
$filename = 'players.json';

// Load players
$players = file_exists($filename) ? json_decode(file_get_contents($filename), true) : [];

// Search functionality
$search = '';
if (isset($_POST['search'])) {
    $search = strtolower(trim($_POST['search']));
    $players = array_filter($players, function($player) use ($search) {
        return strpos(strtolower($player['name']), $search) !== false ||
               strpos(strtolower($player['position']), $search) !== false ||
               strpos(strtolower($player['playtype']), $search) !== false ||
               strpos(strtolower($player['phone']), $search) !== false;
    });
}

// Add player
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_player'])) {
    $id = time();
    $name = $_POST['name'];
    $position = $_POST['position'];
    $playtype = $_POST['playtype'];
    $phone = $_POST['phone'];
    $status = 'published';

    $imagePath = 'uploads/default.png';
    if (!empty($_FILES['image']['name'])) {
        $imageName = $id . '_' . basename($_FILES['image']['name']);
        $targetFile = "uploads/" . $imageName;
        move_uploaded_file($_FILES['image']['tmp_name'], $targetFile);
        $imagePath = $targetFile;
    }

    $players[] = [
        'id' => $id,
        'name' => $name,
        'position' => $position,
        'playtype' => $playtype,
        'phone' => $phone,
        'image' => $imagePath,
        'status' => $status
    ];

    file_put_contents($filename, json_encode($players, JSON_PRETTY_PRINT));
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Toggle publish/unpublish
if (isset($_GET['toggle'])) {
    foreach ($players as &$player) {
        if ($player['id'] == $_GET['toggle']) {
            $player['status'] = $player['status'] === 'published' ? 'unpublished' : 'published';
            break;
        }
    }
    file_put_contents($filename, json_encode($players, JSON_PRETTY_PRINT));
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Delete player
if (isset($_GET['delete'])) {
    $players = array_filter($players, fn($p) => $p['id'] != $_GET['delete']);
    file_put_contents($filename, json_encode(array_values($players), JSON_PRETTY_PRINT));
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Player Management</title>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            background-color: #f0f4f8;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 80%;
            margin: 40px auto;
            padding: 20px;
            background-color: #fff;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .form-container {
            margin-bottom: 30px;
        }
        input, select, button {
            width: 100%;
            padding: 12px;
            margin: 8px 0;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 16px;
            background-color: #f9f9f9;
        }
        input[type="file"] {
            width: auto;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        .table-container {
            margin-top: 40px;
            overflow-x: auto;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border: 1px solid #ddd;
            background-color: #fafafa;
        }
        th {
            background-color: #f1f1f1;
        }
        img {
            height: 50px;
            border-radius: 8px;
        }
        .actions {
            text-align: center;
        }
        .actions a {
            text-decoration: none;
            color: #007bff;
            margin-right: 10px;
        }
        .actions a:hover {
            color: #0056b3;
        }
        .actions a.delete {
            color: #dc3545;
        }
        .actions a.delete:hover {
            color: #c82333;
        }
        .search-container {
            margin-bottom: 20px;
            display: flex;
            justify-content: center;
        }
        .search-container input {
            width: 300px;
        }
        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.4);
            overflow: auto;
            padding-top: 60px;
        }
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 500px;
            border-radius: 10px;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>➕ নতুন প্লেয়ার যুক্ত করুন</h2>

    <!-- Add Player Button -->
    <button id="addPlayerBtn">প্লেয়ার যোগ করুন</button>

    <!-- Modal for Player Form -->
    <div id="addPlayerModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2>প্লেয়ার ফর্ম</h2>
            <form method="POST" enctype="multipart/form-data">
                <input type="text" name="name" placeholder="প্লেয়ারের নাম" required><br>
                <!-- Position Dropdown -->
                <select name="position" required>
                    <option value="">পজিশন নির্বাচন করুন</option>
                    <option value="Forward">ফরওয়ার্ড</option>
                    <option value="Midfielder">মিডফিল্ডার</option>
                    <option value="Defender">ডিফেন্ডার</option>
                    <option value="Goalkeeper">গোলকিপার</option>
                    <option value="Wicketkeeper">উইকেটকিপার</option>
                    <option value="Batsman">ব্যাটসম্যান</option>
                    <option value="Bowler">বোলার</option>
                    <option value="Allrounder">অলরাউন্ডার</option>
                    <option value="Striker">স্ট্রাইকার</option>
                    <option value="Mid">মিড</option>
                </select><br>

                <!-- Playtype Dropdown -->
                <select name="playtype" required>
                    <option value="">খেলার ধরন নির্বাচন করুন</option>
                    <option value="Football">ফুটবল</option>
                    <option value="Cricket">ক্রিকেট</option>
                    <option value="Basketball">বাস্কেটবল</option>
                    <option value="Tennis">টেনিস</option>
                    <option value="Badminton">ব্যাডমিন্টন</option>
                    <option value="Hockey">হকি</option>
                    <option value="Volleyball">ভলিবল</option>
                    <option value="Table Tennis">টেবিল টেনিস</option>
                </select><br>

                <input type="text" name="phone" placeholder="ফোন নাম্বার" required><br>
                <input type="file" name="image" accept="image/*"><br>
                <button type="submit" name="add_player">প্লেয়ার যোগ করুন</button>
            </form>
        </div>
    </div>

    <!-- Search Box -->
    <div class="search-container">
        <form method="POST">
            <input type="text" name="search" placeholder="খোঁজুন..." value="<?= htmlspecialchars($search) ?>">
            <button type="submit">খুঁজুন</button>
        </form>
    </div>

    <div class="table-container">
        <h2>📋 প্লেয়ার তালিকা</h2>
        <table>
            <tr>
                <th>ইমেজ</th>
                <th>নাম</th>
                <th>পজিশন</th>
                <th>খেলার ধরন</th>
                <th>ফোন</th>
                <th>স্ট্যাটাস</th>
                <th>অ্যাকশন</th>
            </tr>
            <?php foreach ($players as $player): ?>
                <tr>
                    <td><img src="<?= $player['image'] ?>" alt=""></td>
                    <td><?= htmlspecialchars($player['name']) ?></td>
                    <td><?= htmlspecialchars($player['position']) ?></td>
                    <td><?= htmlspecialchars($player['playtype']) ?></td>
                    <td><?= htmlspecialchars($player['phone']) ?></td>
                    <td><?= $player['status'] ?></td>
                    <td class="actions">
                        <a href="?toggle=<?= $player['id'] ?>"><?= $player['status'] === 'published' ? 'Unpublish' : 'Publish' ?></a>
                        <a href="?delete=<?= $player['id'] ?>" onclick="return confirm('এই প্লেয়ারটি ডিলিট করতে চান?')">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>
</div>

<script>
    // Modal functionality
    var modal = document.getElementById("addPlayerModal");
    var btn = document.getElementById("addPlayerBtn");
    var span = document.getElementsByClassName("close")[0];

    btn.onclick = function() {
        modal.style.display = "block";
    }

    span.onclick = function() {
        modal.style.display = "none";
    }

    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>

</body>
</html>
