<?php
$history = [];
$file = 'policies.json';

if (file_exists($file)) {
    $history = json_decode(file_get_contents($file), true);
}

$latest = end($history);
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>📄 Latest HelpLine Policy</title>
    <style>
        body {
            font-family: sans-serif;
            background: #f0f0f0;
            padding: 40px;
        }

        .policy-box {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 0 8px rgba(0,0,0,0.1);
        }

        .timestamp {
            color: #666;
            font-size: 13px;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>

<h2>📢 সর্বশেষ প্রাইভেসি পলিসি</h2>

<div class="policy-box">
    <?php if ($latest): ?>
        <div class="timestamp">🕒 আপডেট সময়: <?= $latest['timestamp'] ?></div>
        <div class="content"><?= $latest['policy_text'] ?></div>
    <?php else: ?>
        <p>🚫 এখনো কোনো পলিসি আপলোড করা হয়নি।</p>
    <?php endif; ?>
</div>

</body>
</html>
