<?php
header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$policy = isset($input['policy_text']) ? $input['policy_text'] : '';

if ($policy) {
    $history = [];
    $file = 'policies.json';

    // Load existing data
    if (file_exists($file)) {
        $history = json_decode(file_get_contents($file), true);
    }

    // Add new entry with timestamp
    $history[] = [
        'policy_text' => $policy,
        'timestamp' => date('Y-m-d H:i:s')
    ];

    file_put_contents($file, json_encode($history, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));

    echo json_encode(['status' => 'success', 'message' => 'Policy saved successfully']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Policy text missing']);
}
