<?php
header('Content-Type: application/json');

$file = 'policies.json';
$history = [];

if (file_exists($file)) {
    $history = json_decode(file_get_contents($file), true);
}

$latest = end($history);

if ($latest) {
    echo json_encode([
        
            'policy_text' => $latest['policy_text'],
            'timestamp' => $latest['timestamp']
        
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'No policy found'
    ]);
}
