<?php
header('Content-Type: application/json; charset=UTF-8');

$dataFile = "user_data.json";

if (!file_exists($dataFile)) {
    file_put_contents($dataFile, json_encode([]));
}

$existingData = json_decode(file_get_contents($dataFile), true);

$device_id = $_POST['device_id'] ?? null;
$description = $_POST['description'] ?? null;
$status = $_POST['status'] ?? null;

date_default_timezone_set('Asia/Dhaka'); 
$currentTime = date("h:i A, d-M-Y");

if ($device_id && $description && $status) {
    $newEntry = [
        "device_id" => $device_id,
        "description" => $description,
        "status" => $status,
        "created_at" => $currentTime
    ];

    $existingData[] = $newEntry;

    file_put_contents($dataFile, json_encode($existingData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

    echo json_encode(["message" => "আবেদন সফলভাবে জমা হয়েছে"], JSON_UNESCAPED_UNICODE);
} else {
    echo json_encode(["message" => "ত্রুটি! সব তথ্য পূর্ণ করুন।"], JSON_UNESCAPED_UNICODE);
}
?>
