<?php
header("Content-Type: application/json");
$filename = "user_data.json";

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!file_exists($filename)) {
        echo json_encode(["message" => "File not found"]);
        exit;
    }

    $jsonData = file_get_contents($filename);
    $data = json_decode($jsonData, true);

    $unique_id = $_POST['unique_id'];
    $action = $_POST['action'];

    $isUpdated = false;

    foreach ($data as &$entry) {
        if ($entry['unique_id'] == $unique_id) {
            if ($action == 'approve') {
                $entry['status'] = 'Approved';
                $isUpdated = true;
            } else if ($action == 'reject') {
                $entry['status'] = 'Rejected';
                $isUpdated = true;
            } else if ($action == 'delete') {
                unset($entry);
                $isUpdated = true;
            }
        }
    }

    if ($action == 'delete') {
        $data = array_values($data);
    }

    if ($isUpdated) {
        file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
        echo json_encode(["message" => "Action performed successfully"]);
    } else {
        echo json_encode(["message" => "No matching unique ID found"]);
    }
}
?>
