<?php
$usersFile = 'users.json';
$approvedFile = 'approved_users.json';

if (!file_exists($usersFile)) {
    echo json_encode(['error' => 'users.json not found']);
    exit;
}

$data = json_decode(file_get_contents($usersFile), true);
$approvedUsers = [];

if (isset($data['users'])) {
    foreach ($data['users'] as $user) {
        if ($user['status'] === 'approved') {
            $approvedUsers[] = $user;
        }
    }
}

file_put_contents($approvedFile, json_encode(['users' => $approvedUsers], JSON_PRETTY_PRINT));
echo json_encode(['message' => 'Approved users updated successfully']);
?>
