<?php
// সিকিউরিটি হেডার
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("X-XSS-Protection: 1; mode=block");
header("Strict-Transport-Security: max-age=31536000; includeSubDomains");
header("Content-Security-Policy: default-src 'self'; script-src 'self'");

// টোকেন ডাটাবেস ফাইল
$token_file = 'api_tokens.json';
$api_tokens = file_exists($token_file) ? json_decode(file_get_contents($token_file), true) : [];

// সার্চ ফিচার চেক (নাম বা কী দিয়ে)
if (isset($_GET['search'])) {
    $search = $_GET['search'];
    $results = [];

    foreach ($api_tokens as $key => $token_data) {
        if (stripos($key, $search) !== false || 
            (isset($token_data['user_name']) && stripos($token_data['user_name'], $search) !== false)) {
            $results[$key] = $token_data;
        }
    }

    if (empty($results)) {
        echo json_encode([
            "error" => true,
            "message" => "No matching results found for '{$search}'."
        ]);
    } else {
        echo json_encode([
            "success" => true,
            "message" => "Matching results found.",
            "results" => $results
        ], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    }
    exit;
}

// টোকেন ডেটা এডিট ফিচার
if (isset($_GET['edit_token']) && isset($api_tokens[$_GET['edit_token']])) {
    $token_key = $_GET['edit_token'];
    $edit_data = json_decode(file_get_contents('php://input'), true);

    if (!$edit_data) {
        echo json_encode([
            "error" => true,
            "message" => "Invalid JSON data provided for editing!"
        ]);
        exit;
    }

    // টোকেন ডেটা আপডেট করা
    foreach ($edit_data as $field => $value) {
        $api_tokens[$token_key][$field] = $value;
    }

    // ডাটাবেসে সেভ করা
    file_put_contents($token_file, json_encode($api_tokens, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

    echo json_encode([
        "success" => true,
        "message" => "Token data updated successfully!",
        "updated_data" => $api_tokens[$token_key]
    ], JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    exit;
}

// টোকেন ডিলিট ফিচার
if (isset($_GET['delete_token']) && isset($api_tokens[$_GET['delete_token']])) {
    $token_key = $_GET['delete_token'];

    // ডিলিট করা
    unset($api_tokens[$token_key]);

    // ডাটাবেস আপডেট করা
    file_put_contents($token_file, json_encode($api_tokens, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

    echo json_encode([
        "success" => true,
        "message" => "Token '{$token_key}' deleted successfully."
    ]);
    exit;
} elseif (isset($_GET['delete_token'])) {
    echo json_encode([
        "error" => true,
        "message" => "Token '{$_GET['delete_token']}' not found."
    ]);
    exit;
}

// ডিফল্ট রেসপন্স
echo json_encode([
    "error" => true,
    "message" => "No valid action provided!"
]);