<?php
// PHP: Google Drive লিংক থেকে ডিরেক্ট লিংক তৈরি
function getDirectLink($driveLink) {
    // শেয়ার করা লিংক থেকে FILE_ID বের করা
    preg_match('/\/d\/(.*?)\//', $driveLink, $matches);
    $fileId = $matches[1] ?? null;

    if ($fileId) {
        return "https://drive.google.com/uc?export=download&id=" . $fileId;
    }
    return null;
}

// আপনার Google Drive লিংক
$driveLink = "https://drive.google.com/file/d/1GzEPILHO9XNVfUkJhUltbK9IwHAk031H/view?usp=drivesdk";
$directLink = getDirectLink($driveLink);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Google Drive Video Player</title>
</head>
<body>
    <h1>Google Drive Video Player</h1>
    <?php if ($directLink): ?>
        <!-- ভিডিও প্লেয়ার -->
        <video width="640" height="360" controls>
            <source src="<?php echo htmlspecialchars($directLink); ?>" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <p>Direct Link: <a href="<?php echo htmlspecialchars($directLink); ?>" target="_blank">Download or Play</a></p>
    <?php else: ?>
        <p style="color: red;">Invalid Google Drive link. Please provide a valid link.</p>
    <?php endif; ?>
</body>
</html>