<?php
// Check if the user provided a Google Drive link
if (!isset($_GET['link'])) {
    header('Content-Type: application/json');
    echo json_encode([
        "status" => "error",
        "message" => "Please provide a Google Drive link using the 'link' parameter."
    ]);
    exit;
}

// Get the Google Drive link from the user
$driveLink = $_GET['link'];

// Extract the File ID from the Google Drive link
preg_match('/\/d\/(.*?)\/|id=(.*?)(\&|$)/', $driveLink, $matches);
$fileId = isset($matches[1]) && !empty($matches[1]) ? $matches[1] : (isset($matches[2]) ? $matches[2] : null);

if (!$fileId) {
    header('Content-Type: application/json');
    echo json_encode([
        "status" => "error",
        "message" => "Invalid Google Drive link. Unable to extract the file ID."
    ]);
    exit;
}

// Create a direct download link
$directLink = "https://drive.google.com/uc?export=download&id=" . $fileId;

// Initialize cURL to fetch file details
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $directLink);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_NOBODY, true); // Only fetch headers

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$contentType = curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
$contentLength = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
curl_close($ch);

// Check if the file is accessible
if ($httpCode !== 200) {
    header('Content-Type: application/json');
    echo json_encode([
        "status" => "error",
        "message" => "Unable to access the file. Please check if the file is publicly shared.",
        "http_code" => $httpCode
    ]);
    exit;
}

// Return the details in JSON format
header('Content-Type: application/json');
echo json_encode([
    "status" => "success",
    "message" => "File details fetched successfully.",
    "file_id" => $fileId,
    "direct_link" => $directLink,
    "content_type" => $contentType,
    "file_size" => $contentLength !== -1 ? round($contentLength / (1024 * 1024), 2) . " MB" : "Unknown",
    "instructions" => "Use the 'direct_link' to download or stream the file."
]);
?>