<?php
// The YouTube video URL to process
$youtubeUrl = "https://www.youtube.com/watch?v=2LSqc4dc1SY";

// API endpoint
$apiUrl = "https://y2meta.tube/search";

// Data to send in the POST request
$postData = [
    'query' => $youtubeUrl
];

// Initialize cURL session
$ch = curl_init();

// Set cURL options
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/x-www-form-urlencoded'
]);

// Execute the cURL request
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo "Error: " . curl_error($ch);
    curl_close($ch);
    exit;
}

// Close the cURL session
curl_close($ch);

// Parse and display the response
$responseData = json_decode($response, true);

if ($responseData) {
    echo "<pre>";
    print_r($responseData);
    echo "</pre>";
} else {
    echo "Failed to retrieve data from the API.";
}
?>
