<?php
// সিকিউরিটি হেডার
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("X-XSS-Protection: 1; mode=block");
header("Strict-Transport-Security: max-age=31536000; includeSubDomains");
header("Content-Security-Policy: default-src 'self'; script-src 'self'");

// API URLs ডিক্লেয়ার করা
$api_urls = [
    "facebook" => "https://api.bots.business/v2/bots/1718425/web-app/downloader_facebook",
    "instagram" => "https://api.bots.business/v2/bots/1718425/web-app/downloader_instagram",
    "twitter" => "https://api.bots.business/v2/bots/1718425/web-app/downloader_twitter",
    "youtube_audio" => "https://api.bots.business/v2/bots/1718425/web-app/downloader_ytAudio",
    "youtube_video" => "https://api.bots.business/v2/bots/1718425/web-app/downloader_ytVideo",
    "spotify" => "https://api.bots.business/v2/bots/1718425/web-app/downloader_spotify",
    "tiktok" => "https://shitolkar.top/api/tikd.php?token=TOKEN_Shitol"
];

// টোকেনের ডেটা সংরক্ষণ করার জন্য JSON ফাইলের পাথ
define('TOKEN_FILE', 'tokens.json');

// টোকেন তৈরি ফাংশন
function generate_token($username, $unlimited_requests = false, $expiry_time = 3600) {
    // টোকেন তৈরির জন্য ইউনিক স্ট্রিং তৈরি
    $token = bin2hex(random_bytes(32)); // নিরাপদ টোকেন
    $device_id = $_SERVER['HTTP_USER_AGENT']; // ডিভাইস আইডি (যে ডিভাইস থেকে রিকোয়েস্ট আসছে)
    $expiry = $unlimited_requests ? 'NULL' : (time() + $expiry_time);

    // টোকেনের ডেটা JSON ফাইলে সেভ করা
    $tokens = get_tokens_from_file();
    $tokens[$token] = [
        'username' => $username,
        'device_id' => $device_id,
        'expiry_time' => $expiry,
        'unlimited_requests' => $unlimited_requests,
        'request_count' => 0
    ];

    // JSON ফাইল আপডেট করা
    file_put_contents(TOKEN_FILE, json_encode($tokens, JSON_PRETTY_PRINT));

    return $token;
}

// JSON ফাইল থেকে টোকেনের ডেটা রিট্রিভ করা
function get_tokens_from_file() {
    if (file_exists(TOKEN_FILE)) {
        $data = file_get_contents(TOKEN_FILE);
        return json_decode($data, true);
    }
    return [];
}

// টোকেন ভ্যালিডেট ফাংশন
function validate_token($token, $device_id) {
    $tokens = get_tokens_from_file();

    if (isset($tokens[$token])) {
        $token_data = $tokens[$token];

        // টোকেন মেয়াদ চেক করা এবং ডিভাইস আইডি মেলানো
        if (($token_data['unlimited_requests'] || time() < $token_data['expiry_time']) && $token_data['device_id'] === $device_id) {
            return true;
        }
    }

    return false;
}

// API রিকোয়েস্ট ট্র্যাকিং ফাংশন
function log_request($token) {
    $tokens = get_tokens_from_file();

    if (isset($tokens[$token])) {
        $tokens[$token]['request_count'] += 1; // রিকোয়েস্ট গোনা

        // JSON ফাইল আপডেট করা
        file_put_contents(TOKEN_FILE, json_encode($tokens, JSON_PRETTY_PRINT));
    }
}

// API URLs এর মাধ্যমে URL যাচাই
function get_api_for_url($url) {
    global $api_urls;

    if (preg_match('/(facebook\.com|fb\.watch)/i', $url)) {
        return $api_urls['facebook'];
    }
    if (preg_match('/(instagram\.com)/i', $url)) {
        return $api_urls['instagram'];
    }
    if (preg_match('/(twitter\.com|x\.com)/i', $url)) {
        return $api_urls['twitter'];
    }
    if (preg_match('/(youtube\.com|youtu\.be)/i', $url)) {
        return $api_urls['youtube_video'];
    }
    if (preg_match('/(spotify\.com)/i', $url)) {
        return $api_urls['spotify'];
    }
    if (preg_match('/(tiktok\.com)/i', $url)) {
        return $api_urls['tiktok'];
    }

    return null;
}

// ফাইল সাইজ মেগাবাইটে রূপান্তর ফাংশন
function get_file_size_in_mb($url) {
    $headers = get_headers($url, 1);

    if (isset($headers['Content-Length'])) {
        $size_in_bytes = $headers['Content-Length'];
        return round($size_in_bytes / (1024 * 1024), 2); // মেগাবাইটে রূপান্তর
    }

    return null;
}

// প্যারামিটার চেক করা
if (isset($_GET['url'])) {
    $url = filter_var($_GET['url'], FILTER_SANITIZE_URL);

    if (!filter_var($url, FILTER_VALIDATE_URL)) {
        echo json_encode([
            "error" => true,
            "message" => "Invalid URL provided!"
        ]);
        exit;
    }

    // টোকেন চেক করা
    if (isset($_GET['token'])) {
        $token = $_GET['token'];
        $device_id = $_SERVER['HTTP_USER_AGENT'];

        if (!validate_token($token, $device_id)) {
            echo json_encode([
                "error" => true,
                "message" => "Invalid or expired token!"
            ]);
            exit;
        }

        // রিকোয়েস্ট লগ করা
        log_request($token);
    }

    $api_url = get_api_for_url($url);

    if ($api_url) {
        $response = @file_get_contents($api_url . "?url=" . urlencode($url));

        if ($response === false) {
            echo json_encode([
                "error" => true,
                "message" => "Failed to connect to the API."
            ]);
            exit;
        }

        $data = json_decode($response, true);

        // Instagram লিংকের জন্য প্রসেসিং
        if (isset($data['data']['result']['video_url'])) {
            $video_url = $data['data']['result']['video_url'];
            $file_size_mb = get_file_size_in_mb($video_url);

            if ($file_size_mb !== null) {
                $data['data']['result']['file_size_mb'] = $file_size_mb . " MB";
            } else {
                $data['data']['result']['file_size_mb'] = "File size not available.";
            }
        }

        // টোকেনের তথ্য রেসপন্সে যোগ করা
        if (isset($token)) {
            $tokens = get_tokens_from_file();
            $token_info = $tokens[$token] ?? null;
            if ($token_info) {
                $data['token_info'] = $token_info;
            }
        }

        header('Content-Type: application/json');
        echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
    } else {
        echo json_encode([
            "error" => true,
            "message" => "No matching API found for the provided URL."
        ]);
    }
} else {
    echo json_encode([
        "error" => true,
        "message" => "Missing 'url' parameter!"
    ]);
}
?>