<?php
// সিকিউরিটি হেডার
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("X-XSS-Protection: 1; mode=block");
header("Strict-Transport-Security: max-age=31536000; includeSubDomains");
header("Content-Security-Policy: default-src 'self'; script-src 'self'");

// টোকেন ফাইলের পাথ
define('TOKEN_FILE', 'tokens.json');

// টোকেন তৈরির ফাংশন
function generate_token($username, $unlimited_requests = false, $expiry_time = '1 hour') {
    $token = bin2hex(random_bytes(32)); // নিরাপদ টোকেন
    $device_id = $_SERVER['HTTP_USER_AGENT']; // ডিভাইস আইডি (যে ডিভাইস থেকে রিকোয়েস্ট আসছে)

    // টাইম কনভার্ট (ঘণ্টা ও মিনিটের জন্য)
    if (strpos($expiry_time, 'hour') !== false) {
        $expiry_seconds = intval($expiry_time) * 3600;
    } elseif (strpos($expiry_time, 'minute') !== false) {
        $expiry_seconds = intval($expiry_time) * 60;
    } else {
        $expiry_seconds = 3600; // ডিফল্ট ১ ঘণ্টা
    }

    // টোকেনের ডেটা JSON ফাইলে সেভ করা
    $tokens = get_tokens_from_file();
    $tokens[$token] = [
        'username' => $username,
        'device_id' => $device_id,
        'expiry_time' => time() + $expiry_seconds,
        'unlimited_requests' => $unlimited_requests,
        'request_count' => 0
    ];

    // JSON ফাইল আপডেট করা
    file_put_contents(TOKEN_FILE, json_encode($tokens, JSON_PRETTY_PRINT));

    return $token;
}

// JSON ফাইল থেকে টোকেনের ডেটা রিট্রিভ করা
function get_tokens_from_file() {
    if (file_exists(TOKEN_FILE)) {
        $data = file_get_contents(TOKEN_FILE);
        return json_decode($data, true);
    }
    return [];
}

// টোকেন অনুসারে ডেটা রিট্রিভ করা
function get_token_details($token) {
    $tokens = get_tokens_from_file();
    return isset($tokens[$token]) ? $tokens[$token] : null;
}

// টোকেন আপডেট করা
function update_token($token, $expiry_time = '1 hour', $unlimited_requests = false) {
    $tokens = get_tokens_from_file();

    if (isset($tokens[$token])) {
        // টাইম কনভার্ট (ঘণ্টা ও মিনিটের জন্য)
        if (strpos($expiry_time, 'hour') !== false) {
            $expiry_seconds = intval($expiry_time) * 3600;
        } elseif (strpos($expiry_time, 'minute') !== false) {
            $expiry_seconds = intval($expiry_time) * 60;
        } else {
            $expiry_seconds = 3600; // ডিফল্ট ১ ঘণ্টা
        }

        // আপডেট করা
        $tokens[$token]['expiry_time'] = time() + $expiry_seconds;
        $tokens[$token]['unlimited_requests'] = $unlimited_requests;

        // JSON ফাইল আপডেট করা
        file_put_contents(TOKEN_FILE, json_encode($tokens, JSON_PRETTY_PRINT));

        return true;
    }
    return false;
}

// টোকেন ডিলিট করা
function delete_token($token) {
    $tokens = get_tokens_from_file();

    if (isset($tokens[$token])) {
        unset($tokens[$token]);
        // JSON ফাইল আপডেট করা
        file_put_contents(TOKEN_FILE, json_encode($tokens, JSON_PRETTY_PRINT));
        return true;
    }
    return false;
}

// ইউজারের টোকেন অনুসারে সার্চ করা
function search_by_username($username) {
    $tokens = get_tokens_from_file();
    $result = [];

    foreach ($tokens as $token => $data) {
        if ($data['username'] === $username) {
            $result[$token] = $data;
        }
    }
    return $result;
}

// API ফাংশনালিটি
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // টোকেন তৈরির রিকোয়েস্ট
    if (isset($_GET['action']) && $_GET['action'] == 'generate') {
        if (isset($_GET['username'])) {
            $username = $_GET['username'];
            $unlimited_requests = isset($_GET['unlimited_requests']) ? $_GET['unlimited_requests'] : false;
            $expiry_time = isset($_GET['expiry_time']) ? $_GET['expiry_time'] : '1 hour';
            $token = generate_token($username, $unlimited_requests, $expiry_time);
            echo json_encode([
                "success" => true,
                "message" => "Token created successfully!",
                "token" => $token
            ]);
        } else {
            echo json_encode([
                "error" => true,
                "message" => "Missing username parameter!"
            ]);
        }
    }
    // টোকেন আপডেট করার রিকোয়েস্ট
    elseif (isset($_GET['action']) && $_GET['action'] == 'update') {
        if (isset($_GET['token'])) {
            $token = $_GET['token'];
            $expiry_time = isset($_GET['expiry_time']) ? $_GET['expiry_time'] : '1 hour';
            $unlimited_requests = isset($_GET['unlimited_requests']) ? $_GET['unlimited_requests'] : false;
            if (update_token($token, $expiry_time, $unlimited_requests)) {
                echo json_encode(["success" => true, "message" => "Token updated successfully!"]);
            } else {
                echo json_encode(["error" => true, "message" => "Token not found!"]);
            }
        } else {
            echo json_encode([
                "error" => true,
                "message" => "Missing token parameter!"
            ]);
        }
    }
    // টোকেন ডিলিট করার রিকোয়েস্ট
    elseif (isset($_GET['action']) && $_GET['action'] == 'delete') {
        if (isset($_GET['token'])) {
            $token = $_GET['token'];
            if (delete_token($token)) {
                echo json_encode(["success" => true, "message" => "Token deleted successfully!"]);
            } else {
                echo json_encode(["error" => true, "message" => "Token not found!"]);
            }
        } else {
            echo json_encode([
                "error" => true,
                "message" => "Missing token parameter!"
            ]);
        }
    }
    // টোকেন ডিটেইলস দেখতে
    elseif (isset($_GET['token'])) {
        $token = $_GET['token'];
        $details = get_token_details($token);
        if ($details) {
            echo json_encode($details, JSON_PRETTY_PRINT);
        } else {
            echo json_encode(["error" => true, "message" => "Token not found!"]);
        }
    }
    // ইউজারের টোকেন অনুসারে সার্চ
    elseif (isset($_GET['username'])) {
        $username = $_GET['username'];
        $result = search_by_username($username);
        if (!empty($result)) {
            echo json_encode($result, JSON_PRETTY_PRINT);
        } else {
            echo json_encode(["error" => true, "message" => "No tokens found for this username!"]);
        }
    }
    // সব টোকেনের সংখ্যা
    elseif (isset($_GET['action']) && $_GET['action'] == 'count') {
        $tokens = get_tokens_from_file();
        echo json_encode(["token_count" => count($tokens)]);
    }
    else {
        echo json_encode(["error" => true, "message" => "Invalid request!"]);
    }
}
else {
    echo json_encode(["error" => true, "message" => "Invalid request method!"]);
}
?>