<?php
header('Content-Type: application/json');

// Function to get IP details from ip-api
function getIPDetails($ip) {
    $url = "http://ip-api.com/json/{$ip}";
    $response = file_get_contents($url);
    return json_decode($response, true);
}

// Get user's current IP
$userIP = $_SERVER['REMOTE_ADDR']; // User's IP address from server
$forwardedIP = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? ''; // Forwarded IP from Proxy/VPN

// Get details for both IPs
$realIPDetails = getIPDetails($userIP);
$vpnIPDetails = $forwardedIP ? getIPDetails($forwardedIP) : null;

// Determine if VPN is in use
$isUsingVPN = false;
if ($vpnIPDetails && $vpnIPDetails['status'] === 'success' && $vpnIPDetails['query'] !== $userIP) {
    $isUsingVPN = true;
}

// Prepare the response data
$response = [
    'real_ip' => $realIPDetails['query'] ?? $userIP,
    'real_location' => [
        'country' => $realIPDetails['country'] ?? 'Unknown',
        'region' => $realIPDetails['regionName'] ?? 'Unknown',
        'city' => $realIPDetails['city'] ?? 'Unknown',
    ],
    'vpn_ip' => $vpnIPDetails['query'] ?? null,
    'vpn_location' => $vpnIPDetails ? [
        'country' => $vpnIPDetails['country'] ?? 'Unknown',
        'region' => $vpnIPDetails['regionName'] ?? 'Unknown',
        'city' => $vpnIPDetails['city'] ?? 'Unknown',
    ] : null,
    'is_vpn_used' => $isUsingVPN,
];

// Output the data as JSON
echo json_encode($response, JSON_PRETTY_PRINT);
?>