<?php
// চ্যানেলের ডেটা
$channel = [
    "category_name" => "LIVE",
    "name" => "T Sports Live 01",
    "logo" => "https://image.tsports.com/images/mobile_logo/1719127161-LIVE.jpg",
    "link" => "https://live-cdn.tsports.com/live-01/index.m3u8",
    "headers" => [
        "Cookie" => "Edge-Cache-Cookie=URLPrefix=aHR0cHM6Ly9saXZlLWNkbi50c3BvcnRzLmNvbS8:Expires=1732869720:KeyName=tsports-ed25519-01:Signature=R-Y_acbA6MMWQFnjGbSV-0yjJ2HD_1shCLWWSkLQUSpC8oOvQSVfSg24fL-QoKZs73Csevbb5TdCyjUYK2o_Dg",
        "Host" => "live-cdn.tsports.com",
        "User-agent" => "https://github.com/byte-capsule (Linux;Android 14)"
    ]
];

// ভিডিও লিঙ্ক
$videoLink = $channel['link'];
$videoLogo = $channel['logo'];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $channel['name']; ?> - Live Stream</title>
    <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            text-align: center;
            padding: 20px;
        }
        video {
            width: 100%;
            max-width: 800px;
            margin: 20px auto;
            display: block;
        }
        img {
            max-width: 200px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>

    <h1><?php echo $channel['name']; ?></h1>
    <img src="<?php echo $videoLogo; ?>" alt="Channel Logo">

    <video id="video" controls autoplay></video>

    <script>
        // HLS.js দিয়ে প্লে করা
        var video = document.getElementById('video');
        if (Hls.isSupported()) {
            var hls = new Hls();
            hls.loadSource('<?php echo $videoLink; ?>');
            hls.attachMedia(video);
            hls.on(Hls.Events.MANIFEST_PARSED, function() {
                video.play();
            });
        } else if (video.canPlayType('application/vnd.apple.mpegurl')) {
            // iOS Safari-এর জন্য
            video.src = '<?php echo $videoLink; ?>';
            video.addEventListener('loadedmetadata', function() {
                video.play();
            });
        } else {
            alert('আপনার ব্রাউজার এই ভিডিও প্লে সমর্থন করে না।');
        }
    </script>

</body>
</html>