# টিক টক ভিডিও ডাউনলোডার - অ্যাডমিন প্যানেল

## Overview
এটি একটি PHP-ভিত্তিক অ্যাডমিন প্যানেল যা TikTok ভিডিও ডাউনলোডার অ্যাপের জন্য তৈরি করা হয়েছে। এখানে নোটিফিকেশন পাঠানো, অ্যাপ কনফিগারেশন ম্যানেজমেন্ট এবং ভিজিটর অ্যানালিটিক্স দেখার সুবিধা রয়েছে।

## Features
- **ড্যাশবোর্ড**: অ্যাপের সামগ্রিক অবস্থা দেখুন
- **নোটিফিকেশন**: অ্যাপ ইউজারদের কাছে পুশ নোটিফিকেশন পাঠান
- **অ্যাপ সেটিংস**: ভার্সন, APK URL, আপডেট টাইপ ইত্যাদি পরিবর্তন করুন
- **অ্যাড সেটিংস**: বিজ্ঞাপন কনফিগারেশন পরিবর্তন করুন
- **অ্যানালিটিক্স**: ভিজিটর ডেটা দেখুন
- **লগইন সিস্টেম**: পাসওয়ার্ড সুরক্ষিত অ্যাক্সেস

## Project Structure
```
├── index.php          # মূল অ্যাডমিন প্যানেল UI
├── login.php          # লগইন পেজ
├── api.php            # API endpoints
├── favicon.svg        # সাইট আইকন
├── data/
│   ├── config.json    # অ্যাপ কনফিগারেশন
│   └── analytics.json # ভিজিটর অ্যানালিটিক্স
├── assets/
│   └── style.css      # CSS স্টাইলিং
└── replit.md          # এই ফাইল
```

## API Endpoints
- `api.php` - ডিফল্ট config JSON আউটপুট দেয়
- `api.php?action=get_config` - অ্যাপ কনফিগারেশন পান
- `api.php?action=get_analytics` - অ্যানালিটিক্স ডেটা পান
- `api.php?action=track_visit` - নতুন ভিজিট ট্র্যাক করুন

## Config JSON Format
```json
{
  "versionCode": 1,
  "apkUrl": "https://example.com/app.apk",
  "updateType": "force",
  "message": "নতুন ভার্সন উপলব্ধ।",
  "forceClose": false,
  "ad_enabled": true,
  "ad_blocker": false,
  "clicks_per_ad": 5,
  "interstitial_id": "ca-app-pub-xxx/xxx"
}
```

## Security Features
- Session-based authentication with 1-hour timeout
- CSRF token protection on all forms
- Password stored as environment variable (ADMIN_PASSWORD)
- Session regeneration after login to prevent fixation attacks

## Environment Variables Required
- `ADMIN_PASSWORD` - অ্যাডমিন প্যানেলে লগইন করার জন্য পাসওয়ার্ড

## External APIs
- নোটিফিকেশন: `https://systemtamim.top/App/send_notification.php?title=&body=`

## Run Command
```bash
php -S 0.0.0.0:5000
```

## Recent Changes
- December 2025: Initial setup with full security implementation
- Added login system with session management
- Implemented CSRF protection
- Created Bengali language UI with TikTok-inspired dark theme
